/****** Object:  StoredProcedure [dbo].[usp_Update_Movement_Request]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Update_Movement_Request]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Update_Movement_Request]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII	
-- Create date: 24.10.2012
-- Description:	Updates a movement request.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Update_Movement_Request] 
	@ID	INT,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@ORDERED_DATE DATETIME,
	@IS_ACTIVE BIT,
	@RELEASED_DATE DATETIME,
	@SIGNED_DATE DATETIME,
	@SIGNED_BY_UID UNIQUEIDENTIFIER,
	@PROVIDER_UID UNIQUEIDENTIFIER,
	@SCHEDULER_UID UNIQUEIDENTIFIER,	
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@HOSPITAL_LOCATION_UID UNIQUEIDENTIFIER,
	@ORDER_TEXT	VARCHAR(MAX),
	@WARD_UID UNIQUEIDENTIFIER,
	@FACILITY_LIST NVARCHAR(MAX)
AS
SET NOCOUNT ON
BEGIN
	
	UPDATE MOVEMENT_REQ
		SET
			DOMAIN_ID = @DOMAIN_ID,
			IEN = @IEN,
			PATIENT_UID = @PATIENT_UID,
			ORDERED_DATE = @ORDERED_DATE,
			IS_ACTIVE = @IS_ACTIVE,
			SIGNED_BY_UID = @SIGNED_BY_UID, 
			SIGNED_DATE = @SIGNED_DATE, 
			RELEASED_DATE = @RELEASED_DATE, 
			SCHEDULER_UID = @SCHEDULER_UID, 
			PROVIDER_UID = @PROVIDER_UID,
			VISTA_SITE_UID = @VISTA_SITE_UID,
			HOSPITAL_LOCATION_UID = @HOSPITAL_LOCATION_UID, 
			WARD_UID = @WARD_UID,
			ORDER_TEXT = @ORDER_TEXT
		WHERE ID = @ID

	DELETE FROM ORDER_FACILITY WHERE ORDER_ID = @ID AND ORDER_TYPE ='TRA'
	INSERT INTO ORDER_FACILITY
		(ORDER_ID, FACILITY_UID, ORDER_TYPE)
	SELECT @ID, S.VALUE, 'TRA'
	FROM dbo.fn_Split(@FACILITY_LIST, ',') AS S
	
	IF @@ERROR<>0 RETURN

END
GO
